/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.java;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.integrator.adaptors.java.VWJavaBaseDialog;
import filenet.vw.integrator.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Node;

class VWJavaConfigurationDialog
extends VWJavaBaseDialog
implements ActionListener {
    private FileDialog m_fileDialog = null;
    private JButton m_browseButton = null;
    private JComboBox m_classNameComboBox = null;

    public VWJavaConfigurationDialog(Frame parent, String componentDescriptor, ClassLoader classLoader) throws Exception {
        super(parent, componentDescriptor, classLoader);
        this.initialize();
    }

    public VWJavaConfigurationDialog(Dialog parent, String componentDescriptor, ClassLoader classLoader) throws Exception {
        super(parent, componentDescriptor, classLoader);
        this.initialize();
    }

    public String getComponentDescriptor() {
        try {
            String targetClass;
            if (this.m_xmlWrapper == null) {
                this.m_xmlWrapper = new VWXMLWrapper("fnpe_java_component_descriptor", "http://www.filenet.com/process");
            }
            Node rootNode = this.m_xmlWrapper.getRootNode();
            this.m_xmlWrapper.setNodeValue(rootNode, "adaptor_name", VWResource.s_javaAdaptorName);
            String description = VWXMLWrapper.getNodeValue(rootNode, "description");
            if (description == null || description.length() == 0) {
                this.m_xmlWrapper.setNodeValue(rootNode, "description", VWResource.s_javaAdaptorDescription);
            }
            this.m_xmlWrapper.setNodeValue(rootNode, "adaptor_class", "filenet.vw.integrator.adaptors.java.VWJavaAdaptor");
            String jarFilePath = this.m_sourceFileTextField.getText();
            if (jarFilePath != null) {
                this.m_xmlWrapper.setNodeValue(rootNode, "jar_file_url", jarFilePath);
            }
            if ((targetClass = this.changeStringToClassName((String)this.m_classNameComboBox.getSelectedItem())) != null) {
                this.m_xmlWrapper.setNodeValue(rootNode, "target_class", targetClass);
            }
            return this.m_xmlWrapper.toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object.equals(this.m_browseButton)) {
            this.onBrowseButton();
        } else if (object.equals(this.m_classNameComboBox)) {
            String className = (String)this.m_classNameComboBox.getSelectedItem();
            if (className != null && className.length() > 0) {
                this.m_okButton.setEnabled(true);
                this.m_okButton.setFocusable(this.m_okButton.isEnabled());
                this.initMethodList(className);
            } else {
                this.m_okButton.setEnabled(false);
                this.m_okButton.setFocusable(this.m_okButton.isEnabled());
                this.m_methodList.setModel(new DefaultListModel());
            }
        } else if (object.equals(this.m_okButton)) {
            this.m_nStatus = 1;
            this.setVisible(false);
        } else if (object.equals(this.m_cancelButton)) {
            this.m_nStatus = 0;
            this.setVisible(false);
        } else if (object.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc080.htm");
        }
    }

    private void initialize() {
        try {
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_javaConfigDialogDim);
            if (dim == null) {
                dim = new Dimension(600, 350);
            }
            this.setSize(dim);
            this.setTitle(VWResource.s_javaConfigDialogTitle);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
            this.m_okButton.setEnabled(false);
            this.m_okButton.setFocusable(this.m_okButton.isEnabled());
            if (this.m_xmlWrapper != null) {
                String value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "jar_file_url");
                if (value != null) {
                    this.m_sourceFileTextField.setText(value);
                    this.initClassComboBox(new File(value));
                }
                if ((value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "target_class")) != null) {
                    this.m_classNameComboBox.setSelectedItem(this.changeClassNameToString(value));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.insets = new Insets(4, 4, 4, 4);
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            JLabel label = new JLabel(VWResource.s_jarFilePath);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_jarFilePath, VWResource.s_jarFilePath);
            panel.add((Component)label, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_sourceFileTextField = new JTextField();
            this.m_sourceFileTextField.setEditable(false);
            VWAccessibilityHelper.setAccessibility(this.m_sourceFileTextField, this, VWResource.s_jarFilePathTextField, VWResource.s_jarFilePathTextField);
            VWAccessibilityHelper.setLabelFor(label, this.m_sourceFileTextField);
            this.m_sourceFileTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)this.m_sourceFileTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_browseButton = new JButton(VWResource.s_ellipse.toString(""));
            this.m_browseButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_browseButton, this, VWResource.s_browse, VWResource.s_browse);
            VWAccessibilityHelper.setLabelFor(label, this.m_browseButton);
            this.m_browseButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)this.m_browseButton, gbCons);
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            label = new JLabel(VWResource.s_javaClass);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_javaClass, VWResource.s_javaClass);
            panel.add((Component)label, gbCons);
            gbCons.gridwidth = 2;
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_classNameComboBox = new JComboBox();
            this.m_classNameComboBox.setEditable(true);
            this.m_classNameComboBox.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_classNameComboBox, this, VWResource.s_javaClassComboBox, VWResource.s_javaClassComboBox);
            VWAccessibilityHelper.setLabelFor(label, this.m_classNameComboBox);
            this.m_classNameComboBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)this.m_classNameComboBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            label = new JLabel(VWResource.s_availableMethods);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_availableMethods, VWResource.s_availableMethods);
            panel.add((Component)label, gbCons);
            gbCons.gridwidth = 3;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.5;
            this.m_methodList = new JList();
            VWAccessibilityHelper.setAccessibility(this.m_methodList, this, VWResource.s_availableMethodsList, VWResource.s_availableMethodsList);
            VWAccessibilityHelper.setLabelFor(label, this.m_methodList);
            this.m_methodList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)new JScrollPane(this.m_methodList), gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void onBrowseButton() {
        try {
            if (this.m_fileDialog == null) {
                if (this.m_parent instanceof Dialog) {
                    this.m_fileDialog = new FileDialog((Dialog)this.m_parent, VWResource.s_selectJarFile, 0);
                } else if (this.m_parent instanceof Frame) {
                    this.m_fileDialog = new FileDialog((Frame)this.m_parent, VWResource.s_selectJarFile, 0);
                }
            }
            if (this.m_fileDialog != null) {
                this.m_fileDialog.setVisible(true);
                String sourceFile = this.m_fileDialog.getFile();
                if (sourceFile != null) {
                    File file = new File(this.m_fileDialog.getDirectory() + sourceFile);
                    this.m_sourceFileTextField.setText(file.toString());
                    this.initClassComboBox(file);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parent, ex.getLocalizedMessage(), VWResource.s_error, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClassComboBox(File sourceFile) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (sourceFile != null) {
                String fileName = sourceFile.getName();
                if (fileName.endsWith(".jar")) {
                    JarFile jarFile = new JarFile(sourceFile);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    if (entries != null) {
                        DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
                        while (entries.hasMoreElements()) {
                            ZipEntry zipEntry = entries.nextElement();
                            if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class")) continue;
                            comboBoxModel.addElement(zipEntry.getName());
                        }
                        this.m_classNameComboBox.setModel(comboBoxModel);
                    }
                } else {
                    throw new VWException("filenet.vw.integrator.adaptors.java.InvalidFile", "The file is invalid: {0}", sourceFile);
                }
                if (this.m_classNameComboBox.getModel().getSize() > 0) {
                    this.m_classNameComboBox.setSelectedIndex(0);
                } else {
                    this.m_classNameComboBox.setSelectedIndex(-1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            String message = VWResource.s_errorReadingFile.toString(ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(this.m_parent, message, VWResource.s_error, 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

